library hddtemp;

uses
  Windows,
  Messages,
  ShellAPI,
  plugins in '..\plugins.pas',
  smart_drv in 'smart_drv.pas',
  strtoicon in 'strtoicon.pas';

{$R *.res}
var main_proc:Tatt_proc;
    MainHWND:THandle;
   wclass:twndclass;
   m_TaskbarCreated:THandle;
   inst,handle:hwnd;
   Started:boolean=false;
   tm:array[0..3] of TNOTIFYICONDATA;
   hdd_temps:array[0..3] of byte=(0,0,0,0);
const TxtColor=$FFFF00;
function inttostr(value:int64):string;
begin
     result:='';
     str(value,result);
end;

function GetDriveTemp(drive:longint):byte;
var i:longint;
begin
     result:=0;
     for i:=0 to 255 do
     begin
          if SCOP[ drive ].attr[ i ].bAttrID=194 then
          begin
               result:=SCOP[ drive ].attr[ i ].Raw[0];
               break;
          end;
     end;
end;

//-------

procedure CreateTrayIcons;
var i:longint;
    icon:THandle;
    s:string;
begin
     for i:=0 to 3 do
     begin
          if hSMARTIOCTL[i] = INVALID_HANDLE_VALUE then continue;

          tm[i].cbSize:=sizeof(tm);
          hdd_temps[i]:=GetDriveTemp(i);
          icon:=StringToIcon (IntToStr(hdd_temps[i]),TxtColor);

          tm[i].hIcon:=icon;
          tm[i].uFlags:=NIF_ICON or NIF_TIP;
          s:='Drive ('+inttostr(i)+') '+HDDInfo[i].Model+' Cache '+inttostr(HDDInfo[i].Cache)+'Kb';
          if length(s)>63 then SetLength(s,63);
          Move(s[1],tm[i].szTip,Length(s));
          tm[i].Wnd:=handle;
          tm[i].uID:=7564+i;
          Shell_NotifyIcon(NIM_ADD , @tm[i]);
          DestroyIcon(icon);
     end;
end;
//------------------
function windowproc(hwn,msg,wpr,lpr:longint):longint;stdcall; //our custom windowproc
var i:longint;
begin
     if msg=longint(m_TaskbarCreated) then
     begin
          for i:=0 to 3 do
          begin
               if hSMARTIOCTL[i] = INVALID_HANDLE_VALUE then continue;
               Shell_NotifyIcon(NIM_DELETE , @tm[i]);
          end;
          CreateTrayIcons;
          result:=0;
          exit;
     end;

     case msg of
     WM_CREATE:begin
                    result:=0;
               end;
     else
         result:=defwindowproc(hwn,msg,wpr,lpr);
     end;
end;
//-----

procedure TimerProc(  hwnd:THandle;uMsg:DWORD;idEvent:DWORD;dwTime:DWORD);stdcall;
var icon:THandle;
    i:longint;
    b:byte;
begin
     ReadSMART;
     for i:=0 to 3 do
     begin
          if hSMARTIOCTL[i] = INVALID_HANDLE_VALUE then continue;
          b:=GetDriveTemp(i);
          if hdd_temps[i]=b then continue;
          hdd_temps[i]:=b;
          icon:=StringToIcon (IntToStr(b),TxtColor);
          tm[i].hIcon:=icon;
          tm[i].uFlags:=NIF_ICON;
          Shell_NotifyIcon(NIM_MODIFY , @tm[i]);
          DestroyIcon(icon);
     end;

end;
//---------

procedure get_plug_info(var Info:TPlugInfo);stdcall;
begin
     info.Menu_Text:='HDD Temperature';
     info.Sign:=ATT_Sign;
     info.PuginType:=PL_RunTime;
end;

procedure exec_plugin(Win_Handle:integer;ATT_Proc:Pointer);stdcall;
begin
     m_TaskbarCreated := RegisterWindowMessage( 'TaskbarCreated');

     if Started then exit;
     main_proc:=ATT_Proc;
     MainHWND:=Win_Handle;
     inst:=getmodulehandle(nil);
     with wclass do //create class properties
     begin
          style:=CS_CLASSDC or CS_PARENTDC;
          lpfnwndproc:=@windowproc; //this is where our custom window proc goes
          hinstance:=inst;
          hbrbackground:=color_btnface+1;
          lpszclassname:='ATTPLGHDDT';
          hcursor:=loadcursor(0,IDC_ARROW);
          wclass.hbrBackground:=COLOR_BTNSHADOW;
          wclass.hIcon:=LoadIcon(0,IDI_APPLICATION);    //Loading default icon file
     end;
     registerclass(wclass);
     handle:=CreateWindowEx(0,'ATTPLGHDDT',nil,0,0,0,0,0,0,0,inst,nil);
     Started:=true;
     OpenSmart;
     ReadSMART;
     CreateTrayIcons;
     SetTimer(handle,7765,10000,@TimerProc);
end;

procedure done_plugin;stdcall;
var i:longint;
begin
     if Started then
     begin
          KillTimer(handle,7765);
          for i:=0 to 3 do
          begin
               if hSMARTIOCTL[i] = INVALID_HANDLE_VALUE then continue;
               Shell_NotifyIcon(NIM_DELETE , @tm[i]);
          end;
          CloseSmart;
          Started:=false;
          DestroyWindow(handle);
          UnRegisterClass('ATTPLGHDDT',inst);
     end;
end;

procedure suspend_restore;stdcall;
begin
     CloseSMART;
     OpenSMART;
end;

procedure config_plugin(Win_Handle:HWND;ATT_Proc:Pointer);stdcall;
begin
     MessageBox(Win_Handle,'No configuration yet.','Information',MB_ICONINFORMATION or MB_OK);
end;

exports
      get_plug_info name 'get_plug_info',
      exec_plugin name 'exec_plugin',
      done_plugin name 'done_plugin',
      suspend_restore name 'suspend_restore',
      config_plugin name 'config_plugin';

begin
end.
